//-------------------------------------------------------------------------
// Preprocessor defines.
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Characteristics of the NVRAM h/w in use, which is a serial EEPROM chip.

// Number of bytes in each serial EEPROM page.
#define NVRAM_PAGE_SIZE (256)

// Total number of serial EEPROM pages.
#define NVRAM_PAGE_COUNT (512)

// Serial EEPROM capacity, in bytes.
#define NVRAM_CAPACITY (NVRAM_PAGE_SIZE * NVRAM_PAGE_COUNT)

#define IOC_NVRAM_GET_OFFSET	_IOWR('p', 0x42, int)	/* Get NVRAM partition offset */
#define IOC_NVRAM_SYNC		_IO('p', 0x43)		/* Sync NVRAM image */
#define IOC_PDS_CLEAR		_IOWR('p', 0x44, int)
#define IOC_PDS_REWRITE_CRC	_IOWR('p', 0x45, int)
#define IOC_PDS_IS_CRC_VALID	_IOR('p', 0x46, int)
#define IOC_PDS_CLEARALL		_IOWR('p', 0x47, int)

#ifdef __KERNEL__
ssize_t m24m01_write(char *buf, size_t count, loff_t pos);
ssize_t m24m01_read(char *buf, size_t count, loff_t pos);
#endif
